<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\Locations;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model backend\models\UserLocations */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="user-locations-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'user_id')->textInput() ?>

<?= $form->field($model, 'location')->dropDownList(ArrayHelper::map(Locations::find()->all(), 'id', 'name'),['prompt'=>'Select location']) ?>

    <?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'zip')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'city')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'state')->textInput(['maxlength' => true]) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<script type="text/javascript">
    //the dropdown list id; This doesn't have to be a dropdown it can be any field type.
    $("#userlocations-location").on("change", function() {
        //the dropdown list selected locations id
        var id = $(this).val();
        //call the action we created above in the conrller
        $.get("user-locations/locationaddress", {id: id},  function(data) {
            //get the JSON data from the action
            var data = $.parseJSON(data);
            //check if the system found any data            
            if (data !== null) {
                //if yes fill the form field with the ids address,city, state & zip.
                //we use .blur because yii will fire validation for those field after they are filled
                $("#userlocations-address").val(data.address).blur();
                $("#userlocations-city").val(data.city).blur();
                $("#userlocations-state").val(data.state).blur();
                $("#userlocations-zip").val(data.zip).blur();
            } else {
                //if data wasn't found the alert.
                alert('We\'re sorry but we couldn\'t load the the location data!');
            }
        });
    });
</script>

</div>
