<?php

use yii\helpers\Html;
use app\models\Transactions;
use kartik\daterange\DateRangePicker;
use kartik\daterange\DateRangeBehavior;
use kartik\grid\GridView;
use dosamigos\datepicker\DatePicker;
use yii\widgets\Pjax;
use yii\helpers\Url;
use app\models\Service;
use kartik\export\ExportMenu;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\TransactionsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Transactions';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="transactions-index">

    
 
    		<?php
			$gridColumns = [
			['class' => 'yii\grid\SerialColumn'],
			'transaction_ref',
			'transac_desc',
			[
				'attribute' => 'transac_date',
				'value' => 'transac_date',
				'format' => 'raw',
				'width' => '150px',
				'filter' => DatePicker::widget([
					'model' => $searchModel,
					'attribute' => 'transac_date',
					'language' => 'en',
					'size' => 'ms',
						'clientOptions' => [
							'autoclose' => true,
							'format' => 'yyyy-mm-dd',
							'todayBtn' => true
							
					]
						
				]),
			],
			
			[// total,
					'attribute' => 'amount',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['amount'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotal($dataProvider->models, 'amount'),
			],
			
			[
					'attribute' => 'expense',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['expense'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalExpense($dataProvider->models, 'expense'),
			],
			
			[
					'attribute' => 'wage',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['wage'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalWage($dataProvider->models, 'wage'),
			],
			
			
				
				
				
				
				
				[
					'attribute' => 'rent',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['rent'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalRent($dataProvider->models, 'rent'),
				],
				[
					'attribute' => 'water',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['water'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalWater($dataProvider->models, 'water'),
				],
				
				[
					'attribute' => 'electricity',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['electricity'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalElectricity($dataProvider->models, 'electricity'),
				],
				[// total,
					'attribute' => 'netcash',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['netcash'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalNet($dataProvider->models, 'netcash'),
				],
			
			['class' => 'yii\grid\ActionColumn'],
		];
		?>
			<div class="row" style="background-color: #EBF5FB; padding-top:15px; margin:0px">
			
			<div class="col-sm-5" style="background-color: #EBF5FB; margin-bottom:0px; padding-bottom:10px;">
			
			<?php echo ExportMenu::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'columns' => $gridColumns,
				'footerRowOptions'=>['style'=>'font-weight:bold; font-size:18px; background-color: #87CEFA ;'],
				'showPageSummary' => true,
				
				 'dropdownOptions' => [
					'label' => 'Export All',
					'class' => 'btn btn-default'
				] 
			]);?>
			<?= Html::a('Add expense', ['expense'], ['class' => 'btn btn-success']) ?>
			<?= Html::a('Add Income', ['income'], ['class' => 'btn btn-success']) ?>
			</div>
			<div class="col-sm-7">
			<?php  echo $this->render('_search', ['model' => $searchModel]); ?>
			</div>
			</div>
						 
						 
	


	<?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,   
		'showFooter' => true, // show footer section of the gridview widget
		'footerRowOptions'=>['style'=>'font-weight:bold; font-size:18px; background-color: #87CEFA ;'],
		'columns' => [
			['class' => 'yii\grid\SerialColumn'],
				'transaction_ref',
				'transac_desc',
				
				
				[
				'attribute' => 'transac_date',
				'value' => 'transac_date',
				'format' => 'raw',
				'width' => '150px',
				'filter' => DatePicker::widget([
					'model' => $searchModel,
					'attribute' => 'transac_date',
					'language' => 'en',
					'size' => 'ms',
						'clientOptions' => [
							'autoclose' => true,
							'format' => 'yyyy-mm-dd',
							'todayBtn' => true
							
					]
						
				]),
				],
				
				
				[// total,
					'attribute' => 'amount',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['amount'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotal($dataProvider->models, 'amount'),
				],
				
				[
					'attribute' => 'expense',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['expense'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalExpense($dataProvider->models, 'expense'),
				],
				
				[
					'attribute' => 'wage',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['wage'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalWage($dataProvider->models, 'wage'),
				],
				[
					'attribute' => 'rent',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['rent'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalRent($dataProvider->models, 'rent'),
				],
				
				[
					'attribute' => 'water',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['water'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalWater($dataProvider->models, 'water'),
				],
				//'rent',
				
				
				[
					'attribute' => 'electricity',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['electricity'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalElectricity($dataProvider->models, 'electricity'),
				],
				
				[
					'attribute' => 'netcash',
					'value' => function($data) {
						// show the amount in money format => 50,000.00
						return number_format($data['netcash'], 2);
					},
					'filter' => true, //disable the filter for this field
					// I create the summary function in my Invoice model
					'footer' => Transactions::getTotalNet($dataProvider->models, 'netcash'),
				],
				/* [
						'label' => 'Net amount',
						'value' => function ($model) {
							return $model->amount - $model->water - $model->rent - $model->electricity - $model->expense;
						}
				],
					 */
					
				[
					'class' => 'yii\grid\ActionColumn',
					'contentOptions' => function ($model, $key, $index, $column) 
					{
						return ['style' => 'min-width:90px']; 
					}
				  
				],
			 
			
			],
		]);
	?></div>
	<?php echo $total;?> = <?= $wage;?> - <?= $sum;?><br>

