<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\datecontrol\DateControl;
//use dosamigos\datepicker\DatePicker;
use kartik\datecontrol\Module;

/* @var $this yii\web\View */
/* @var $model backend\models\ServiceSearch */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="service-search">

    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
    ]); ?>

    
	<div class="row" >
		<div class="col-sm-4">
			<?= $form->field($model, 'transactionFrom')
			->label(false)
			->widget(DateControl::classname(), [
			 'options' => ['placeholder'=>'Enter start date'],
			 'type'=>DateControl::FORMAT_DATE,
			 'ajaxConversion'=>false,
			 'widgetOptions' => [
				'pluginOptions' => [
					'autoclose' => true,
					'todayHighlight' => true,
					'todayBtn' => true
					
				]
			]
		]);
		
		
		
		 ?>
		</div>
		<div class="col-sm-4">
			<?= $form->field($model, 'transactionTo')
			->label(false)
			->widget(DateControl::classname(), [
				'type'=>DateControl::FORMAT_DATE,
				'ajaxConversion'=>false,
				'widgetOptions' => [
					'pluginOptions' => [
						'autoclose' => true,
						'todayHighlight' => true,
						'todayBtn' => true
						
					]
				]
			]);
				 ?>

		</div>

    <div class="form-group">
		<div class="col-sm-2">
        <?= Html::submitButton('Search', ['class' => 'btn btn-primary']) ?>
		</div>
		<div class="col-sm-2">
        <?php echo Html::a('Reset','index.php?r=transactions', ['class' => 'btn btn-primary']) ?>
		</div>
    </div>
</div>
    <?php ActiveForm::end(); ?>

</div>
