<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model backend\models\Transactions */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="transactions-form">

    <?php $form = ActiveForm::begin(); ?>
	<div class="col-sm-4">
	<?= $form->field($model, 'transaction_ref', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'readonly'=>true,'placeholder'=>'Reference Number']) ?>

    <?= $form->field($model, 'transac_desc')->textInput(['maxlength' => true]) ?>

   
	<?= $form->field($model, 'transac_date', ['labelOptions'=>['class'=>'labelchange']])->widget(DatePicker::classname(), [
						'options' => ['placeholder' => 'Sales date', 'value' => date('Y-m-d'),'endDate' => '0d'],
						//'removeButton' => false,
						'pluginOptions' => [
							'autoclose'=>true,
							'format' => 'yyyy-mm-dd'
						]
            ]);?>
	
	<?php //echo $form->field($model, 'amount')->textInput(['maxlength' => true, 'class' => 'itemoid','readOnly'=> true, 'hidden'=> true])->label(false) ?>
	
	<?php if ($model->amount > 0) : ?>  
	
	<?= $form->field($model, 'amount')->textInput()?>
	<?php else: ?>
	<?= $form->field($model, 'expense')->textInput() ?>
	
	<?php endif; ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
	
	</div>

    <?php ActiveForm::end(); ?>

</div>
