<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use wbraganca\dynamicform\DynamicFormWidget;
use richardfan\widget\JSRegister;
//use kartik\widgets\DatePicker;
use kartik\date\DatePicker;
use yii\helpers\ArrayHelper;
use app\models\Owner;
use app\models\Attendant;
use kartik\select2\Select2;
use app\models\Items;
use yii\web\View;
use app\assets\ExternalAsset;
use yii\bootstrap\Modal;
use yii\helpers\Url;
use yii\widgets\Pjax;
use app\models\employees;





/* @var $this yii\web\View */
/* @var $model backend\models\Po */
/* @var $form yii\widgets\ActiveForm */

?>




<div class="service-form">
	

    <?php $form = ActiveForm::begin(['id' => 'dynamic-form']); ?>
	<?php Pjax::begin(['id' => 'ownerowner', 'timeout' => 10000, 'enablePushState' => false]); ?>
	<div class="row" style="background-color: #EBF5FB">
	<div class="panel-heading" style="background-color:#0174DF"><h4><i class="glyphicon glyphicon-envelope"></i> Service(s) Sales</h4></div>
	
		<div class="col-sm-4">
			<table width="100%">
				<tr>
					<td width="80%" >
							<?= $form->field($model, 'ser_own_id', ['labelOptions'=>['class'=>'labelchange']])->widget(Select2::classname(),[
									'data'=> /* ['newclient' => 'Add New'] +  */ArrayHelper::map(Owner::find()->all(),'owner_id','owner'),
									'language'=>'en',
									'options'=>['placeholder'=>'Select customers name', 'id'=>'zipCode'],
									'pluginOptions'=>[
										'allowClear'=>true
						],
					]);
					?>
					</td>		
					<td width="10%" height="2%">
						<?php echo Html::button('+', ['value' => Url::to('index.php?r=owner/new'), 'class' => 'btn btn-success', 'id' => 'modalButton']);?>
					</td>	
				</tr>
			</table>
	
	
			

			

		</div>
		
		
		<div class="col-sm-4">
			
			<?= $form->field($model, 'phone_no', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true]) ?>
		</div>
		
		<div class="col-sm-4">
			<?= $form->field($model, 'ref_no', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'readonly'=>true,'placeholder'=>'Reference Number']) ?>

			<?= $form->field($model, 'servicedate', ['labelOptions'=>['class'=>'labelchange']])->widget(DatePicker::classname(), [
						'options' => ['placeholder' => 'Sales date', 'value' => date('Y-m-d'),'endDate' => '0d'],
						//'removeButton' => false,
						'pluginOptions' => [
							'autoclose'=>true,
							'format' => 'yyyy-mm-dd'
						]
            ]);
							
			?>

		</div>	
		
	</div>
	
	<?php Pjax::end(); ?>
	
	<div class="row">
	
	<div class="panel panel-default">
        <div class="panel-heading"><h4><i class="glyphicon glyphicon-envelope"></i> Service(s) offered</h4></div>
        <div class="panel-body">
             <?php DynamicFormWidget::begin([
                'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                'widgetBody' => '.container-items', // required: css class selector
                'widgetItem' => '.item', // required: css class
                'limit' => 4, // the maximum times, an element can be cloned (default 999)
                'min' => 1, // 0 or 1 (default 1)
                'insertButton' => '.add-item', // css class
                'deleteButton' => '.remove-item', // css class
                'model' => $modelsServiceItem[0],
                'formId' => 'dynamic-form',
                'formFields' => [
                    'ser_name',
                    'ser_descr',
					'price',
                    'qnty',
					'amount',
					
                    
                ],
            ]); ?>

            <div class="container-items"><!-- widgetContainer -->
            <?php foreach ($modelsServiceItem as $i => $modelServiceItem): ?>
                <div class="item panel panel-default"><!-- widgetBody -->
                    <div class="panel-heading">
                       
                        <div class="pull-right">
                            <button type="button" class="add-item btn btn-success btn-xs"><i class="glyphicon glyphicon-plus"></i></button>
                            <button type="button" class="remove-item btn btn-danger btn-xs"><i class="glyphicon glyphicon-minus"></i></button>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-body">
                        <?php
                            // necessary for update action.
                            if (! $modelServiceItem->isNewRecord) {
                                echo Html::activeHiddenInput($modelServiceItem, "[{$i}]id");
                            }
                        ?>
                        
                        <div class="row">
                            <div class="col-sm-3">
               								
							<?= $form->field($modelServiceItem, "[{$i}]ser_name", ['labelOptions'=>['class'=>'labelchange']])->dropDownList(
                            arrayhelper::map(Items::find()->all(),'itemes_id','ser_name'),
                            ['prompt'=>'select Service', 'onchange' => 'getProduct($(this))'  , 'onkeyup' => 'getProduct($(this))' ]
                            );
							?>
							<?php
		Modal::begin([
			'header' => '<h4>Vehicle owner<h4>',
			'id' => 'modal',
			'size' => 'modal-sm',
		]);

		echo "<div id='modalContent'></div>";

		Modal::end();
	?>
							
							
							
							
                            </div>
							
							
                            <div class="col-sm-5">
                                <?= $form->field($modelServiceItem, "[{$i}]ser_descr", ['labelOptions'=>['class'=>'labelchange']])->textarea(['rows' => 1]) ?>
                                
                            </div>
														
							<div class="col-sm-1">
                                <?= $form->field($modelServiceItem, "[{$i}]price", ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'price','readOnly'=> true]) ?>
                            </div>
							
							<div class="col-sm-1">
                                <?= $form->field($modelServiceItem, "[{$i}]qnty", ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'qnty']) ?>
                            </div>
							
							<div class="col-sm-2">
                                <?= $form->field($modelServiceItem, "[{$i}]amount", ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'amount','readOnly'=> true]) ?>
                            </div>
							<div class="col-sm-2">
                                <?= $form->field($modelServiceItem, "[{$i}]itemoid", ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'itemoid','readOnly'=> true, 'hidden'=> true])->label(false) ?>
                            </div>
							
							
							
							
							
                        </div><!-- .row -->
                      
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
            <?php DynamicFormWidget::end(); ?>
			<div class="row" style="background-color: #EBF5FB">
				<div class="col-xs-4 col-sm-4 col-lg-4">
					<?= $form->field($model, 'total', ['labelOptions'=>['class'=>'labelchange']])->textInput(['maxlength' => true, 'class' => 'total','readOnly'=> true]) ?>
				</div>
				
			</div>
			
        </div>
		
    </div>
	
	
					 
                     
	
	</div>
	 
	
	
	
	<?= $form->field($model, 'attendant')->widget(Select2::classname(),[
					'data'=>ArrayHelper::map(Employees::find()->all(),'name','name'),
					'language'=>'en',
					'options'=>['placeholder'=>'Select attendant'],
					'pluginOptions'=>[
						'allowClear'=>true
		],
	]);?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php
$script = <<< JS
	
	
    //Js for getting owner details form db
    
    $('#zipCode').change(function(){
		var zipId = $(this).val();
		 if(zipId == 'newclient'){
		$('#modal').modal('show')
		
		} 
        
        $.get('index.php?r=owner/details',{ zipId: zipId }, function(data){
          /*  var data=$.parseJSON(data); // This is not necessary any more... */
            $('#service-veh_model').val(data.veh_model);
		//$('#service-veh_make').val(data.veh_make);
		//$('#service-owner').val(data.owner);
		$('#service-phone_no').val(data.phone_no);
        });
    });


    //Js for getting products form db
    
	function getProduct(item) {
       var index  = item.attr("id").replace(/[^0-9.]/g, "");
       var itemes_id =$('#serviceitem-'+index+'-ser_name').val();
        
       $.get('index.php?r=items/price',{ itemes_id : itemes_id },function(data)
       {
          //var data = $.parseJSON(data);
    
         $('#serviceitem-'+index+'-ser_descr').val(data.ser_descr); 
		 $('#serviceitem-'+index+'-itemoid').val(data.itemoid);
         $('#serviceitem-'+index+'-price').val(data.price);
    	 $('#serviceitem-'+index+'-qnty').val(data.qnty);
    	 getAmount();
       });
    }
    
    
    var getAmount = function() {

        var items = $(".item");
        var amount = 0;
        var total = 0;
		var commission = '';
		var netcash = '';
		

        items.each(function (index, elem) {
			
            var qnty = $(elem).find(".qnty").val();
			
            var price = $(elem).find(".price").val();
			
			//alert(qnty);

			
            //Check if qnty and price are numeric or something like that
            
			amount = parseInt(qnty) * parseInt(price);
			//amount = qnty * price;
			
			
            //Assign the amount value to the field
            $(elem).find(".amount").val(amount);

            var amountValue = $(elem).find(".amount").val();

            total = parseInt(total) + parseInt(amountValue);

            $(".total").val(total);
			
			
			commission = (40 / 100) * parseInt(total);
			
			$(".commission").val(commission);
			
			netcash = parseInt(total) - parseInt(commission);
			
			$(".netcash").val(netcash);
			
        });
    };
	 
	 //Bind new elements to support the function too
    $(".container-items").on("change", function() {
        
    });
	
	//Bind new elements to support the function too
    $(".price, .qnty").on("keyup", function() {
        getAmount();
    });
	
	
	
	
	
	

	
	



JS;
$this->registerJs($script, $this::POS_END);
?>






