<?php

use yii\helpers\Html;
use yii\grid\GridView;
use backend\models\Receipt;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\ReceiptSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Receipts';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="receipt-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Receipt', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    
	<?= GridView::widget([
   'dataProvider' => $dataProvider,
   'filterModel' => $searchModel,
   'showFooter' => true,
   'columns' => [
       ['class' => 'yii\grid\SerialColumn'],

       [
         'attribute' => 'patient_id',
         'value' => 'patient.patient_name'
       ],
	   'reg_date',
       [
         'attribute' => 'price',
         'footer' => Receipt::getTotal($dataProvider->models, 'price'),       
       ],

       ['class' => 'yii\grid\ActionColumn'],
    ],
]); ?>
</div>
