<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\models\Attendant */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Attendants', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="attendant-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->att_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->att_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'att_id',
            'name',
            'phone',
            'address:ntext',
            'id_number',
        ],
    ]) ?>

</div>
