<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\AttendantSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Attendants';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="attendant-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Attendant', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'att_id',
            'name',
            'phone',
            'address:ntext',
            'id_number',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
