<?php

use yii\helpers\Html;
use yii\grid\GridView;
use mdm\admin\components\Helper;

/* @var $this yii\web\View */
/* @var $searchModel mdm\admin\models\searchs\User */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('rbac-admin', 'Users');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <?=
    GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'username',
			'firstname',
			'secondname',
            'email:email',
            [
                'attribute' => 'status',
                'value' => function($model) {
                    return $model->status == 0 ? 'Inactive' : 'Active';
                },
                'filter' => [
                    0 => 'Inactive',
                    10 => 'Active'
                ]
            ],
            [
                'class' => 'yii\grid\ActionColumn',
				//'template'=>'{view} {update} {payment} {delete}',
                'template' => '{view} {update}{delete}{activate} {deactivate} ',
                'buttons' => [
                    'activate' => function($url, $model) {
                        if ($model->status == 10) {
                            return '';
                        }
                        $options = [
                            'title' => Yii::t('rbac-admin', 'Activate'),
                            'aria-label' => Yii::t('rbac-admin', 'Activate'),
                            'data-confirm' => Yii::t('rbac-admin', 'Are you sure you want to activate this user?'),
                            'data-method' => 'post',
                            'data-pjax' => '0',
                        ];
                        return Html::a('<span class="glyphicon glyphicon-ok"></span>', $url, $options);
                    },
					
					'deactivate' => function($url, $model) {
                        if ($model->status == 0) {
                            return '';
                        }
                        $options = [
                            'title' => Yii::t('rbac-admin', 'Deactivate'),
                            'aria-label' => Yii::t('rbac-admin', 'Deactivate'),
                            'data-confirm' => Yii::t('rbac-admin', 'Are you sure you want to Deactivate this user?'),
                            'data-method' => 'post',
                            'data-pjax' => '0',
                        ];
                        return Html::a('<span class="glyphicon glyphicon-remove"></span>', $url, $options);
                    }
                    ]
                ], 
            ],
        ]);
        ?>
</div>

<?php
/* protected function initDefaultButtons()

	{

		if (!isset($this->buttons['view'])) {

			$this->buttons['view'] = function ($model, $key, $index, $column) {

				

				$url = $column->createUrl($model, $key, $index, 'view');

				return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url, [

					'title' => Yii::t('yii', 'View'),

				]);

			};

		}

		if (!isset($this->buttons['update'])) {

			$this->buttons['update'] = function ($model, $key, $index, $column) {

				

				$url = $column->createUrl($model, $key, $index, 'update');

				return Html::a('<span class="glyphicon glyphicon-pencil"></span>', $url, [

					'title' => Yii::t('yii', 'Update'),

				]);

			};

		}

		if (!isset($this->buttons['delete'])) {

			$this->buttons['delete'] = function ($model, $key, $index, $column) {

			

				$url = $column->createUrl($model, $key, $index, 'delete');

				return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url, [

					'title' => Yii::t('yii', 'Delete'),

					'data-confirm' => Yii::t('yii', 'Are you sure to delete this item?'),

					'data-method' => 'post',

				]);

			};

		}

	} */

?>



