<?php

namespace backend\models;

use Yii;
use common\models\User;
/**
 * This is the model class for table "user_locations".
 *
 * @property int $id
 * @property int $user_id
 * @property string $location
 * @property string $address
 * @property string $zip
 * @property string $city
 * @property string $state
 *
 * @property User $user
 */
class UserLocations extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'user_locations';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['location', 'address', 'zip', 'city', 'state'], 'required'],
            [['user_id'], 'integer'],
			[['user_id'], 'safe'],
            [['location', 'zip'], 'string', 'max' => 20],
            [['address'], 'string', 'max' => 50],
            [['city', 'state'], 'string', 'max' => 100],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'location' => 'Location',
            'address' => 'Address',
            'zip' => 'Zip',
            'city' => 'City',
            'state' => 'State',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
