<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "transactions".
 *
 * @property int $id
 * @property int $amount
 * @property string $transac_desc
 * @property string $transac_date
 * @property string $wage
 */
class Transactions extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'transactions';
    }

    /**
     * {@inheritdoc}
     */
	
	public function rules()
    {
        return [
            [['amount','expense'], 'integer'],
			[['rent', 'water', 'electricity', 'wage','netcash',], 'number'],
			[['transaction_ref'], 'string', 'max' => 10],
            [['transac_desc'], 'string', 'max' => 100],
			[['transac_date'], 'safe'],
        ];
    }

 
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            //'id' => 'ID',
            'amount' => 'Total paid',
			'expense' => 'Expense amount',
            'transac_desc' => 'Transaction desc.',
            'transac_date' => 'Transaction date',
			'transaction_ref' => 'Transaction. refno',
			//'expense' => 'expense', 
			'rent' => 'Rent', 
			'water' => 'Water', 
			'electricity' => 'Electricity',
			'wage' => 'Wage', 
        ];
    }
	
	
	public static function getTotal($provider, $fieldName)
	{
		$amount = 0;

		foreach ($provider as $item) {
			$amount += $item[$fieldName];
		}

		// add number_format() before return
		$amount = number_format( $amount, 2 );

		return $amount;
	}
	
	
	public static function getTotalNet($provider, $fieldName)
	{
		$netcash = 0;

		foreach ($provider as $item) {
			$netcash += $item[$fieldName];
		}

		// add number_format() before return
		$netcash = number_format( $netcash, 2 );

		return $netcash;
	}
	
	public static function getTotalRent($provider, $fieldName)
	{
		$rent = 0;

		foreach ($provider as $item) {
			$rent += $item[$fieldName];
		}

		// add number_format() before return
		$rent = number_format( $rent, 2 );

		return $rent;
	}
	public static function getTotalWater($provider, $fieldName)
	{
		$water = 0;

		foreach ($provider as $item) {
			$water += $item[$fieldName];
		}

		// add number_format() before return
		$water = number_format( $water, 2 );

		return $water;
	}
	
	public static function getTotalWage($provider, $fieldName)
	{
		$wage = 0;

		foreach ($provider as $item) {
			$wage += $item[$fieldName];
		}

		// add number_format() before return
		$wage = number_format( $wage, 2 );

		return $wage;
	}
	
	public static function getTotalElectricity($provider, $fieldName)
	{
		$electricity = 0;

		foreach ($provider as $item) {
			$electricity += $item[$fieldName];
		}

		// add number_format() before return
		$electricity = number_format( $electricity, 2 );

		return $electricity;
	}
	
	public static function getTotalExpense($provider, $fieldName)
	{
		$expense = 0;

		foreach ($provider as $item) {
			$expense += $item[$fieldName];
		}

		// add number_format() before return
		$expense = number_format( $expense, 2 );

		return $expense;
	}
	
	
	public function afterSave($insert, $changedAttributes)
	{
		if($insert){
			//sebagai sample saja untuk mengenerate nomor invoice
			//format : tahun-bulan-id database
			$number = date('Y').date('m').str_pad($this->id,4,0,STR_PAD_LEFT);
			$this->updateAttributes(['transaction_ref'=>$number]);
		}
		parent::afterSave($insert, $changedAttributes);
	}
	
}
