<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "service_item".
 *
 * @property int $id
 * @property string $ser_name
 * @property string $ser_descr
 * @property int $price
 * @property int $qnty
 * @property int $amount
 * @property int $service_id
 */
class ServiceItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'service_item';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['ser_name', 'ser_descr', 'price', 'qnty', 'amount'], 'required'],
			[['price', 'qnty', 'amount'], 'safe'],
            [['ser_descr'], 'string'],
            [['price', 'qnty', 'amount', 'service_id', 'itemoid','id'], 'integer'],
            [['ser_name'], 'string', 'max' => 20],
			[['itemoid'], 'exist', 'skipOnError' => true, 'targetClass' => Items::className(), 'targetAttribute' => ['itemoid' => 'itemes_id']], 
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'ser_name' => 'Service name',
            'ser_descr' => 'Description',
            'price' => 'Price',
            'qnty' => 'Quantity',
            'amount' => 'Amount',
            'service_id' => 'Service ID',
			 'itemoid' => 'Itemo ID',
        ];
    }
	
	/** 
    * @return \yii\db\ActiveQuery 
    */ 
   public function getItem() 
   { 
       return $this->hasOne(Items::className(), ['itemes_id' => 'itemoid']); 
   } 
}
