<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "expense".
 *
 * @property int $id
 * @property string $description
 * @property string $date
 * @property int $amount
 */
class Expense extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'expense';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description', 'date', 'amount'], 'required'],
            [['date'], 'safe'],
            [['amount'], 'integer'],
            [['description'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'description' => 'Description',
            'date' => 'Date',
            'amount' => 'Amount',
        ];
    }
}
