<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "employees".
 *
 * @property int $id
 * @property string $name
 * @property int $id_no
 * @property string $Phone
 * @property string $physical_address
 * @property string $next_of_kin
 * @property string $start_date
 */
class Employees extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'employees';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'id_no', 'Phone', 'physical_address', 'next_of_kin', 'start_date'], 'required'],
            [['id_no'], 'integer'],
            [['start_date'], 'safe'],
            [['name'], 'string', 'max' => 40],
            [['Phone'], 'string', 'max' => 12],
            [['physical_address'], 'string', 'max' => 100],
            [['next_of_kin'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Employee name',
            'id_no' => 'ID. number',
            'Phone' => 'Phone number',
            'physical_address' => 'Physical Address',
            'next_of_kin' => 'Next Of Kin',
            'start_date' => 'Start Date',
        ];
    }
}
