<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "attendant".
 *
 * @property int $att_id
 * @property string $name
 * @property int $phone
 * @property string $address
 * @property int $id_number
 */
class Attendant extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'attendant';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'phone', 'address', 'id_number'], 'required'],
            [['phone', 'id_number'], 'integer'],
            [['address'], 'string'],
            [['name'], 'string', 'max' => 40],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'att_id' => 'Att ID',
            'name' => 'Name',
            'phone' => 'Phone',
            'address' => 'Address',
            'id_number' => 'Id Number',
        ];
    }
}
