<?php

namespace app\controllers;

use Yii;
use app\models\Owner;
use app\models\OwnerSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\JsonParser;
use yii\helpers\Json;

/**
 * OwnerController implements the CRUD actions for Owner model.
 */
class OwnerController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
	public function actionAdd() 
	{ 
		$model = new Owner();

		if ($model->load(Yii::$app->request->post()) && $model->save())
		{
			echo 1;
		}
		else 
		{
			return $this->renderAjax('create', [
				'model' => $model,
			]);
		};
	}

    /**
     * Lists all Owner models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new OwnerSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Owner model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Owner model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionNew()
    /* {
        $model = new Owner();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
			Yii::$app->session->setFlash('success', 'Vehicle added successful');
			return $this->redirect('index.php?r=service/create');
        }
		return $this->renderAjax('new', ['model' => $model,]);
		
    } */
	
	
	{
        $model = new Owner();

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        } else {
            // in the post ( 'ensembleStaff_ids' => [0 => '2']); where the id actually is staff_id
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
					Yii::$app->session->setFlash('success', 'Vehicle added successful');
					return $this->redirect('index.php?r=service/create');
            } else {
                return $this->renderAjax('_form', [
                    'model' => $model,
                ]);
            }
        }
    }
	
	
	
	
	
	public function actionCreate()
    {
        $model = new Owner();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->owner_id]);
        }

        return $this->renderAjax('create', [
            'model' => $model,
        ]);
    }
	
	/* public function actionDetails($zipId)
	{
		$location = Owner::findOne($zipId);
		echo Json::encode($location); 
	} */
	
	public function actionDetails($zipId) 
	{
		$location = Owner::findOne($zipId);
		\Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
		return $location;
	}

    /**
     * Updates an existing Owner model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->owner_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Owner model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Owner model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Owner the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Owner::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
