<?php

namespace app\controllers;

use Yii;
use app\models\Items;
use app\models\ItemsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\JsonParser;
use yii\helpers\Json;
use yii\web\ForbiddenHttpException;

/**
 * ItemsController implements the CRUD actions for Items model.
 */
class ItemsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
	
	/* if(Yii::$app->user->can('View all customers records'))
		{
				
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}    */

    /**
     * Lists all Items models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ItemsSearch();
		/* if(Yii::$app->user->can('View all services records'))
		{ */
			$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

			return $this->render('index', [
				'searchModel' => $searchModel,
				'dataProvider' => $dataProvider,
			]);	
		/* }
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		} */
        
    }
	
	/* public function actionPrice($itemes_id)
	{
		$location = Items::findOne($itemes_id);
		echo Json::encode($location); 
	} */
	
	public function actionPrice($itemes_id) 
	{
		$location = Items::findOne($itemes_id);
		\Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
		return $location;
	}
    /**
     * Displays a single Items model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
		if(Yii::$app->user->can('View single service record'))
		{
				 return $this->render('view', [
				'model' => $this->findModel($id),
			]);	
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
       
    }

    /**
     * Creates a new Items model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    /* public function actionCreate()
    {
        $model = new Items();

        if ($model->load(Yii::$app->request->post())) 
		{
			$valid = $model->validate();
			//$model->itemes_id;
			//$model->save();
			
			 $model->itemoid = $this->itemes_id;
			//$model->save();
			
            return $this->redirect(['view', 'id' => $model->itemes_id]);
        }
		

        return $this->render('create', [
            'model' => $model,
        ]);
    } */
	
	public function actionCreate()
    {
        $model = new Items();
		if(Yii::$app->user->can('Create new service'))
		{
				if ($model->load(Yii::$app->request->post())) {
			//$valid = $model->validate();
			  /*  if ($valid) 
			   { */
					if (/* $flag =  */$model->save(false)) 
					{      
						$model->itemoid = $model->itemes_id;
						$model->save();		    
					}   
				//} 
				return $this->redirect(['view', 'id' => $model->itemes_id]); 
			  }
			return $this->render('create', [
				'model' => $model,
			]);	
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}

        
    }
	
	/* public function actionNew()
    {
        $model = new Items();
		if(Yii::$app->user->can('View all customers records'))
		{
				
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}

        if ($model->load(Yii::$app->request->post())) {
		$valid = $model->validate();
           if ($valid) 
		   {
                if ($flag = $model->save(false)) 
				{      
                    $model->itemoid = $model->itemes_id;
					$model->save();		    
                }   
            } 
			return $this->redirect(['view', 'id' => $model->itemes_id]); 
		  }
        return $this->renderAjax('create', [
            'model' => $model,
        ]);
    } */

    /**
     * Updates an existing Items model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
		if(Yii::$app->user->can('Update services records'))
		{
				$model = $this->findModel($id);

			if ($model->load(Yii::$app->request->post()) && $model->save()) {
				return $this->redirect(['view', 'id' => $model->itemes_id]);
			}

			return $this->render('update', [
				'model' => $model,
			]);	
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
        
    }

    /**
     * Deletes an existing Items model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
		if(Yii::$app->user->can('Delete services records'))
		{
			$this->findModel($id)->delete();

			return $this->redirect(['index']);	
		}
		else
		{
			throw new ForbiddenHttpException('Access level is restricted from performing the operation. Contact your admin/manager');
		}
       
    }

    /**
     * Finds the Items model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Items the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Items::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
